///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Timer_Thread(LPVOID);
HANDLE Timer_Thread_Handle;
DWORD Timer_Thread_ID;

bool ExitWaitForDisconnect(Client *);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Timer_Thread(LPVOID data)
{
//    if(glConnectInterval < 10)
//        glConnectInterval = 10;

    while(!gbKillApplication)
    {
        DWORD TimeCount = 0;

        while((TimeCount < (glConnectInterval * 60)) && !gbConnectNow)
        {
            Sleep(1000);
            TimeCount++;
        }

        gbConnectNow = false;

        ConnectAndBeginTransaction();
    }

	return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ExitWaitForDisconnect(Client *pClient)
{
    if(pClient->Connected)
    {
        pClient->Disconnect = true;

        while(pClient->Connected)
        {
            // Waiting for client to be disconnected
            Sleep(1);
        }
    }

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ConnectAndBeginTransaction(void)
{
	char IPAddress[24];

    if(MyClient.Connected)
    {
        WriteLog("Already connected.");
        return ExitWaitForDisconnect(&MyClient);
    }

    Set_Text(MDI.RecvEdit_hWnd, "");

    WriteLog("Please wait... Connecting.");

	if(!GetTrueIPAddress(gsWPServer, IPAddress))
    {
        WriteLog("Error resolving hostname.");
        return false;
    }

    if(MyClient.Connect(IPAddress, 6632))
    {
        WriteLog("Connected.");
    }
    else{
        WriteLog("Failed to connect.");

        return ExitWaitForDisconnect(&MyClient);
    }

    WriteLog("Waiting on server to respond.");

    int AuthResult = AuthenticateWithServer();
    if(AuthResult == AUTH_CMD_SUCCESS)
    {
        WriteLog("Authentication: Success.");
        DoConnect();
    }
    else if(AuthResult == AUTH_CMD_FAILED){
        WriteLog("Authentication: Failed.");
        MyClient.Disconnect = true;
        return ExitWaitForDisconnect(&MyClient);
    }
    else if(AuthResult == AUTH_CMD_DISCONNECT){
        WriteLog("Authentication: Disconnected.");
        MyClient.Disconnect = true;
        return ExitWaitForDisconnect(&MyClient);
    }
    else if(AuthResult == AUTH_CMD_UNKNOWN){
        WriteLog("Authentication: Unknown command.");
        MyClient.Disconnect = true;
        return ExitWaitForDisconnect(&MyClient);
    }
    else{
        WriteLog("Authentication: Error.");
        MyClient.Disconnect = true;
        return ExitWaitForDisconnect(&MyClient);
    }

    char ReceiveData[MaxReceiveSize + 1];
    int ReceiveSize = 0;

    WriteLog("You are now connected.");

    SimpleClientSend("::RequestFirstStatement");

    while(MyClient.Connected)
    {
        if(MyClient.GetReceiveData(ReceiveData, &ReceiveSize) )
        {
            ReceiveData[ReceiveSize] = '\0';

            int CmdResult = ProcessCommand(ReceiveData, ReceiveSize);
            if(CmdResult == COMMAND_RESULT_UNKNOWN)
            {
                WriteLog("Received unknown command.");
                return ExitWaitForDisconnect(&MyClient);
            }
            else if(CmdResult == COMMAND_RESULT_DISCONNECT){
                return ExitWaitForDisconnect(&MyClient);
            }
            else if(CmdResult == COMMAND_RESULT_OK){
                // All is well
            }
            else{
                WriteLog("An error occured processing a received command.");
                return ExitWaitForDisconnect(&MyClient);
            }
        }
        else Sleep(1);

        Sleep(glTCPLoopDelay);
    }

    return ExitWaitForDisconnect(&MyClient);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

